/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.optifine.util.IntExpiringCache;

public abstract class IntExpiringCache<T> {
    private final int intervalMs;
    private long timeCheckMs;
    private Int2ObjectOpenHashMap<Wrapper<T>> map = new Int2ObjectOpenHashMap();

    public IntExpiringCache(int intervalMs) {
        this.intervalMs = intervalMs;
    }

    public T get(int key) {
        Wrapper w;
        long timeNowMs = System.currentTimeMillis();
        if (!this.map.isEmpty() && timeNowMs >= this.timeCheckMs) {
            this.timeCheckMs = timeNowMs + (long)this.intervalMs;
            long timeMinMs = timeNowMs - (long)this.intervalMs;
            IntSet keys = this.map.keySet();
            IntIterator it = keys.iterator();
            while (it.hasNext()) {
                Wrapper w2;
                int k = it.nextInt();
                if (k == key || (w2 = (Wrapper)this.map.get(k)).getAccessTimeMs() > timeMinMs) continue;
                it.remove();
            }
        }
        if ((w = (Wrapper)this.map.get(key)) == null) {
            Object obj = this.make();
            w = new Wrapper(obj);
            this.map.put(key, (Object)w);
        }
        w.setAccessTimeMs(timeNowMs);
        return (T)w.getValue();
    }

    protected abstract T make();
}

