/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.expr.ExpressionParser;
import net.optifine.expr.ExpressionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionBool;
import net.optifine.expr.IExpressionFloat;
import net.optifine.expr.IExpressionResolver;
import net.optifine.expr.ParseException;
import net.optifine.shaders.config.MacroExpressionResolver;
import net.optifine.util.StrUtils;

public class MacroState {
    private boolean active = true;
    private Deque<Boolean> dequeState = new ArrayDeque();
    private Deque<Boolean> dequeResolved = new ArrayDeque();
    private Map<String, String> mapMacroValues = new HashMap();
    public static final Pattern PATTERN_DIRECTIVE = Pattern.compile("\\s*#\\s*(\\w+)\\s*(.*)");
    private static final Pattern PATTERN_DEFINED = Pattern.compile("defined\\s+(\\w+)");
    private static final Pattern PATTERN_DEFINED_FUNC = Pattern.compile("defined\\s*\\(\\s*(\\w+)\\s*\\)");
    private static final Pattern PATTERN_MACRO = Pattern.compile("(\\w+)");
    private static final String DEFINE = "define";
    private static final String UNDEF = "undef";
    private static final String IFDEF = "ifdef";
    private static final String IFNDEF = "ifndef";
    private static final String IF = "if";
    private static final String ELSE = "else";
    private static final String ELIF = "elif";
    private static final String ENDIF = "endif";
    private static final List<String> MACRO_NAMES = Arrays.asList("define", "undef", "ifdef", "ifndef", "if", "else", "elif", "endif");

    public boolean processLine(String line) {
        Matcher m2 = PATTERN_DIRECTIVE.matcher(line);
        if (!m2.matches()) {
            return this.active;
        }
        String name = m2.group(1);
        String param = m2.group(2);
        int posComment = param.indexOf("//");
        if (posComment >= 0) {
            param = param.substring(0, posComment);
        }
        boolean activePrev = this.active;
        this.processMacro(name, param);
        this.active = !this.dequeState.contains(Boolean.FALSE);
        return this.active || activePrev;
    }

    public static boolean isMacroLine(String line) {
        Matcher m2 = PATTERN_DIRECTIVE.matcher(line);
        if (!m2.matches()) {
            return false;
        }
        String name = m2.group(1);
        return MACRO_NAMES.contains(name);
    }

    private void processMacro(String name, String param) {
        String rest;
        StringTokenizer tok = new StringTokenizer(param, " \t");
        String macro = tok.hasMoreTokens() ? tok.nextToken() : "";
        String string = rest = tok.hasMoreTokens() ? tok.nextToken("").trim() : "";
        if (name.equals(DEFINE)) {
            this.mapMacroValues.put(macro, rest);
            return;
        }
        if (name.equals(UNDEF)) {
            this.mapMacroValues.remove(macro);
            return;
        }
        if (name.equals(IFDEF)) {
            boolean act = this.mapMacroValues.containsKey(macro);
            this.dequeState.add(act);
            this.dequeResolved.add(act);
            return;
        }
        if (name.equals(IFNDEF)) {
            boolean act = !this.mapMacroValues.containsKey(macro);
            this.dequeState.add(act);
            this.dequeResolved.add(act);
            return;
        }
        if (name.equals(IF)) {
            this.checkEmpty(param, "Missing #if expression");
            boolean act = this.eval(param);
            this.dequeState.add(act);
            this.dequeResolved.add(act);
            return;
        }
        if (this.dequeState.isEmpty()) {
            return;
        }
        if (name.equals(ELIF)) {
            boolean lastState = (Boolean)this.dequeState.removeLast();
            boolean lastResolved = (Boolean)this.dequeResolved.removeLast();
            if (lastResolved) {
                this.dequeState.add(false);
                this.dequeResolved.add(lastResolved);
            } else {
                this.checkEmpty(param, "Missing #elif expression");
                boolean act = this.eval(param);
                this.dequeState.add(act);
                this.dequeResolved.add(act);
            }
            return;
        }
        if (name.equals(ELSE)) {
            boolean lastState = (Boolean)this.dequeState.removeLast();
            boolean lastResolved = (Boolean)this.dequeResolved.removeLast();
            boolean act = !lastResolved;
            this.dequeState.add(act);
            this.dequeResolved.add(true);
            return;
        }
        if (name.equals(ENDIF)) {
            this.dequeState.removeLast();
            this.dequeResolved.removeLast();
            return;
        }
    }

    private void checkEmpty(String val, String message) {
        if (StrUtils.isEmpty((String)val)) {
            throw new RuntimeException(message);
        }
    }

    private boolean eval(String str) {
        Matcher md2 = PATTERN_DEFINED.matcher((CharSequence)str);
        str = md2.replaceAll("defined_$1");
        Matcher mdf = PATTERN_DEFINED_FUNC.matcher((CharSequence)str);
        str = mdf.replaceAll("defined_$1");
        boolean replaced = false;
        int count = 0;
        block2: do {
            replaced = false;
            Matcher mmn = PATTERN_MACRO.matcher((CharSequence)str);
            while (mmn.find()) {
                char ch;
                String match = mmn.group();
                if (match.length() <= 0 || !Character.isLetter(ch = match.charAt(0)) && ch != '_' || !this.mapMacroValues.containsKey(match)) continue;
                String val = (String)this.mapMacroValues.get(match);
                if (val == null) {
                    val = "1";
                }
                int start = mmn.start();
                int end2 = mmn.end();
                str = ((String)str).substring(0, start) + " " + val + " " + ((String)str).substring(end2);
                replaced = true;
                ++count;
                continue block2;
            }
        } while (replaced && count < 100);
        if (count >= 100) {
            Config.warn((String)("Too many iterations: " + count + ", when resolving: " + (String)str));
            return true;
        }
        try {
            MacroExpressionResolver er = new MacroExpressionResolver(this.mapMacroValues);
            ExpressionParser ep = new ExpressionParser((IExpressionResolver)er);
            IExpression expr = ep.parse((String)str);
            if (expr.getExpressionType() == ExpressionType.BOOL) {
                IExpressionBool exprBool = (IExpressionBool)expr;
                boolean ret = exprBool.eval();
                return ret;
            }
            if (expr.getExpressionType() == ExpressionType.FLOAT) {
                IExpressionFloat exprFloat = (IExpressionFloat)expr;
                float val = exprFloat.eval();
                boolean ret = val != 0.0f;
                return ret;
            }
            throw new ParseException("Not a boolean or float expression: " + String.valueOf(expr.getExpressionType()));
        }
        catch (ParseException e2) {
            Config.warn((String)("Invalid macro expression: " + (String)str));
            Config.warn((String)("Error: " + e2.getMessage()));
            return false;
        }
    }
}

