/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.optifine.Log;
import net.optifine.reflect.IResolvable;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReflectorMethod
implements IResolvable {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName) {
        this(reflectorClass, targetMethodName, null);
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes) {
        this.reflectorClass = reflectorClass;
        this.targetMethodName = targetMethodName;
        this.targetMethodParameterTypes = targetMethodParameterTypes;
        ReflectorResolver.register((IResolvable)this);
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class cls = this.reflectorClass.getTargetClass();
        if (cls == null) {
            return null;
        }
        try {
            if (this.targetMethodParameterTypes == null) {
                Method[] ms = ReflectorMethod.getMethods((Class)cls, (String)this.targetMethodName);
                if (ms.length <= 0) {
                    Log.log((String)("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName));
                    return null;
                }
                if (ms.length > 1) {
                    Log.warn((String)("(Reflector) More than one method found: " + cls.getName() + "." + this.targetMethodName));
                    for (int i2 = 0; i2 < ms.length; ++i2) {
                        Method m2 = ms[i2];
                        Log.warn((String)("(Reflector)  - " + String.valueOf(m2)));
                    }
                    return null;
                }
                this.targetMethod = ms[0];
            } else {
                this.targetMethod = ReflectorMethod.getMethod((Class)cls, (String)this.targetMethodName, (Class[])this.targetMethodParameterTypes);
            }
            if (this.targetMethod == null) {
                Log.log((String)("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName));
                return null;
            }
            this.targetMethod.setAccessible(true);
            return this.targetMethod;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        if (this.checked) {
            return this.targetMethod != null;
        }
        return this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method tm = this.getTargetMethod();
        if (tm == null) {
            return null;
        }
        return tm.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }

    public Object call(Object ... params) {
        return Reflector.call((ReflectorMethod)this, (Object[])params);
    }

    public boolean callBoolean(Object ... params) {
        return Reflector.callBoolean((ReflectorMethod)this, (Object[])params);
    }

    public int callInt(Object ... params) {
        return Reflector.callInt((ReflectorMethod)this, (Object[])params);
    }

    public long callLong(Object ... params) {
        return Reflector.callLong((ReflectorMethod)this, (Object[])params);
    }

    public float callFloat(Object ... params) {
        return Reflector.callFloat((ReflectorMethod)this, (Object[])params);
    }

    public double callDouble(Object ... params) {
        return Reflector.callDouble((ReflectorMethod)this, (Object[])params);
    }

    public String callString(Object ... params) {
        return Reflector.callString((ReflectorMethod)this, (Object[])params);
    }

    public Object call(Object param) {
        return Reflector.call((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public boolean callBoolean(Object param) {
        return Reflector.callBoolean((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public int callInt(Object param) {
        return Reflector.callInt((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public long callLong(Object param) {
        return Reflector.callLong((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public float callFloat(Object param) {
        return Reflector.callFloat((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public double callDouble(Object param) {
        return Reflector.callDouble((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public String callString1(Object param) {
        return Reflector.callString((ReflectorMethod)this, (Object[])new Object[]{param});
    }

    public void callVoid(Object ... params) {
        Reflector.callVoid((ReflectorMethod)this, (Object[])params);
    }

    public static Method getMethod(Class cls, String methodName, Class[] paramTypes) {
        Method[] ms = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Class[] types;
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName) || !Reflector.matchesTypes((Class[])paramTypes, (Class[])(types = m2.getParameterTypes()))) continue;
            return m2;
        }
        return null;
    }

    public static Method[] getMethods(Class cls, String methodName) {
        ArrayList<Method> listMethods = new ArrayList<Method>();
        Method[] ms = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName)) continue;
            listMethods.add(m2);
        }
        Method[] methods = listMethods.toArray(new Method[listMethods.size()]);
        return methods;
    }

    public void resolve() {
        Method m2 = this.getTargetMethod();
    }
}

