/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements dvq {
    private final htn chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private eoh[] blockStates;
    private dxo[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(eoh.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(dxo.class, 16);

    public ChunkCacheOF(htn chunkCache, jw sectionPos) {
        this.chunkCache = chunkCache;
        int minChunkX = sectionPos.u() - 1;
        int minChunkY = sectionPos.v() - 1;
        int minChunkZ = sectionPos.w() - 1;
        int maxChunkX = sectionPos.u() + 1;
        int maxChunkY = sectionPos.v() + 1;
        int maxChunkZ = sectionPos.w() + 1;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(is pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(dww type, is pos) {
        return this.chunkCache.a(type, pos);
    }

    public eoh a_(is pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        eoh iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (eoh[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (dxo[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        eqq chunk = this.chunkCache.getLevelChunk(jw.a((int)this.posX) + 1, jw.a((int)this.posY) + 1, jw.a((int)this.posZ) + 1);
        BlockPosM pos = new BlockPosM();
        for (int y2 = 16; y2 < 32; ++y2) {
            int dy = y2 * this.sizeXZ;
            for (int z = 16; z < 32; ++z) {
                int dz = z * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    eoh bs;
                    pos.setXyz(this.posX + x, this.posY + y2, this.posZ + z);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((is)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int getCombinedLight(eoh blockStateIn, dvq worldIn, is blockPosIn) {
        if (blockStateIn.hasEmissive()) {
            return LightCacheOF.getPackedLightRaw((dvq)worldIn, (eoh)blockStateIn, (is)blockPosIn);
        }
        int index = this.getPositionIndex(blockPosIn);
        if (index < 0 || index >= this.combinedLights.length || this.combinedLights == null) {
            return LightCacheOF.getPackedLightRaw((dvq)worldIn, (eoh)blockStateIn, (is)blockPosIn);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = LightCacheOF.getPackedLightRaw((dvq)worldIn, (eoh)blockStateIn, (is)blockPosIn);
        }
        return light;
    }

    public dxo getBiome(is pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        dxo biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public elb c_(is pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean k(is pos) {
        return this.chunkCache.k(pos);
    }

    public flb b_(is pos) {
        return this.a_(pos).y();
    }

    public int a(is blockPosIn, dvz colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public fkq C_() {
        return this.chunkCache.C_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(iz directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int L_() {
        return this.chunkCache.L_();
    }

    public int K_() {
        return this.chunkCache.K_();
    }
}

