/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.EnumSet;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vec3M
extends ftm
implements jn {
    public Vec3M() {
        super(0.0, 0.0, 0.0);
    }

    public Vec3M(double xIn, double yIn, double zIn) {
        super(xIn, yIn, zIn);
    }

    public Vec3M(Vector3f vecIn) {
        super((Vector3fc)vecIn);
    }

    public Vec3M set(double x, double y2, double z) {
        this.g = x;
        this.h = y2;
        this.i = z;
        return this;
    }

    public Vec3M set(ftm vec) {
        return this.set(vec.g, vec.h, vec.i);
    }

    public Vec3M subtractReverse(ftm vec) {
        return this.set(vec.g - this.g, vec.h - this.h, vec.i - this.i);
    }

    public Vec3M normalize() {
        double d0 = Math.sqrt(this.g * this.g + this.h * this.h + this.i * this.i);
        return d0 < 1.0E-4 ? this.set(0.0, 0.0, 0.0) : this.set(this.g / d0, this.h / d0, this.i / d0);
    }

    public double b(ftm vec) {
        return this.g * vec.g + this.h * vec.h + this.i * vec.i;
    }

    public Vec3M crossProduct(ftm vec) {
        return this.set(this.h * vec.i - this.i * vec.h, this.i * vec.g - this.g * vec.i, this.g * vec.h - this.h * vec.g);
    }

    public Vec3M subtract(ftm vec) {
        return this.subtract(vec.g, vec.h, vec.i);
    }

    public Vec3M sub(ftm vec) {
        return this.subtract(vec.g, vec.h, vec.i);
    }

    public Vec3M subtract(double x, double y2, double z) {
        return this.add(-x, -y2, -z);
    }

    public Vec3M add(ftm vec) {
        return this.add(vec.g, vec.h, vec.i);
    }

    public Vec3M add(double x, double y2, double z) {
        return this.set(this.g + x, this.h + y2, this.i + z);
    }

    public Vec3M scale(double factor) {
        return this.mul(factor, factor, factor);
    }

    public Vec3M inverse() {
        return this.scale(-1.0);
    }

    public Vec3M mul(ftm vec) {
        return this.mul(vec.g, vec.h, vec.i);
    }

    public Vec3M mul(double factorX, double factorY, double factorZ) {
        return this.set(this.g * factorX, this.h * factorY, this.i * factorZ);
    }

    public Vec3M mul(double val) {
        return this.mul(val, val, val);
    }

    public Vec3M lerp(Vec3M vec, double factor) {
        return this.set(bgj.d((double)factor, (double)this.g, (double)vec.g), bgj.d((double)factor, (double)this.h, (double)vec.h), bgj.d((double)factor, (double)this.i, (double)vec.i));
    }

    public Vec3M rotatePitch(float pitch) {
        float f = bgj.b((double)pitch);
        float f1 = bgj.a((double)pitch);
        double d0 = this.g;
        double d1 = this.h * (double)f + this.i * (double)f1;
        double d2 = this.i * (double)f - this.h * (double)f1;
        return this.set(d0, d1, d2);
    }

    public Vec3M rotateYaw(float yaw) {
        float f = bgj.b((double)yaw);
        float f1 = bgj.a((double)yaw);
        double d0 = this.g * (double)f + this.i * (double)f1;
        double d1 = this.h;
        double d2 = this.i * (double)f - this.g * (double)f1;
        return this.set(d0, d1, d2);
    }

    public Vec3M zRot(float angle) {
        float f = bgj.b((double)angle);
        float f1 = bgj.a((double)angle);
        double d0 = this.g * (double)f + this.h * (double)f1;
        double d1 = this.h * (double)f - this.g * (double)f1;
        double d2 = this.i;
        return this.set(d0, d1, d2);
    }

    public Vec3M align(EnumSet<iz.a> axes) {
        double d0 = axes.contains(iz.a.a) ? (double)bgj.c((double)this.g) : this.g;
        double d1 = axes.contains(iz.a.b) ? (double)bgj.c((double)this.h) : this.h;
        double d2 = axes.contains(iz.a.c) ? (double)bgj.c((double)this.i) : this.i;
        return this.set(d0, d1, d2);
    }

    public double a(iz.a axis) {
        return axis.a(this.g, this.h, this.i);
    }

    public Vec3M with(iz.a axis, double distance) {
        double d0 = axis == iz.a.a ? distance : this.g;
        double d1 = axis == iz.a.b ? distance : this.h;
        double d2 = axis == iz.a.c ? distance : this.i;
        return this.set(d0, d1, d2);
    }

    public void setRgb(int rgb) {
        double r = (double)(rgb >> 16 & 0xFF) / 255.0;
        double g = (double)(rgb >> 8 & 0xFF) / 255.0;
        double b2 = (double)(rgb & 0xFF) / 255.0;
        this.set(r, g, b2);
    }

    public Vec3M fromRgbM(int rgb) {
        this.setRgb(rgb);
        return this;
    }

    public double distanceSquared(double x, double y2, double z) {
        double dx = this.g - x;
        double dy = this.h - y2;
        double dz = this.i - z;
        return dx * dx + dy * dy + dz * dz;
    }
}

