/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.render.RenderState;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties<amo>> mapProperties = new HashMap();
    private static Map<String, RandomEntityProperties<amo>> mapSpriteProperties = new HashMap();
    private static boolean active = false;
    private static RandomEntity randomEntity = new RandomEntity();
    private static RandomTileEntity randomTileEntity = new RandomTileEntity();
    private static boolean working = false;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String SEPARATOR_DIGITS = ".";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE = "optifine/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, cur.class, String[].class, (int)0);
    private static final String[] HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, cur.class, String[].class, (int)1);

    public static void entityLoaded(cgk entity, dwo world) {
        if (world == null) {
            return;
        }
        ama edm = entity.aD();
        edm.spawnPosition = entity.dK();
        edm.spawnBiome = (dxo)world.z(edm.spawnPosition).a();
        if (entity instanceof cwz) {
            cwz esr = (cwz)entity;
            RandomEntities.checkEntityShoulder((cwz)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(cgk entity, dwo world) {
        if (entity instanceof cwz) {
            cwz esr = (cwz)entity;
            RandomEntities.checkEntityShoulder((cwz)esr, (boolean)true);
        }
    }

    public static void checkEntityShoulder(cwz entity, boolean attach) {
        chl owner = entity.U_();
        if (owner == null) {
            owner = Config.getMinecraft().s;
        }
        if (!(owner instanceof hne)) {
            return;
        }
        hne player = (hne)owner;
        UUID entityUuid = entity.cY();
        if (attach) {
            player.lastAttachedEntity = entity;
        } else {
            ama edm = entity.aD();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.cY(), (Object)entityUuid)) {
                ama edmShoulderLeft = player.entityShoulderLeft.aD();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.cY(), (Object)entityUuid)) {
                ama edmShoulderRight = player.entityShoulderRight.aD();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(dwo oldWorld, dwo newWorld) {
        if (newWorld instanceof hif) {
            hif newWorldClient = (hif)newWorld;
            Iterable entities = newWorldClient.f();
            for (cgk entity : entities) {
                RandomEntities.entityLoaded((cgk)entity, (dwo)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static amo getTextureLocation(amo loc) {
        if (!active) {
            return loc;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                amo amo2 = loc;
                return amo2;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                amo amo3 = loc;
                return amo3;
            }
            amo amo4 = (amo)props.getResource(re, (Object)loc);
            return amo4;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        elb te;
        if (RenderState.getEntity() != null) {
            randomEntity.setEntity(RenderState.getEntity());
            return randomEntity;
        }
        if (RenderState.getBlockEntity() != null && (te = RenderState.getBlockEntity()).j() != null) {
            randomTileEntity.setTileEntity(te);
            return randomTileEntity;
        }
        return null;
    }

    public static IRandomEntity getRandomEntity(cgk entityIn) {
        randomEntity.setEntity(entityIn);
        return randomEntity;
    }

    public static IRandomEntity getRandomBlockEntity(elb tileEntityIn) {
        randomTileEntity.setTileEntity(tileEntityIn);
        return randomTileEntity;
    }

    private static RandomEntityProperties<amo> makeProperties(amo loc, RandomEntityContext.Textures context) {
        RandomEntityProperties props;
        String path = loc.a();
        amo locProps = RandomEntities.getLocationProperties((amo)loc, (boolean)context.isLegacy());
        if (locProps != null && (props = RandomEntityProperties.parse((amo)locProps, (amo)loc, (RandomEntityContext)context)) != null) {
            return props;
        }
        int[] variants = RandomEntities.getLocationsVariants((amo)loc, (boolean)context.isLegacy(), (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        String name = context.getConnectedParser().parseName(loc.a());
        return new RandomEntityProperties(name, loc, variants, (RandomEntityContext)context);
    }

    private static amo getLocationProperties(amo loc, boolean legacy) {
        String path;
        String pathBase;
        String pathProps;
        amo locMcp = RandomEntities.getLocationRandom((amo)loc, (boolean)legacy);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        amo locProps = new amo(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((amo)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        amo locParentProps = new amo(domain, pathParent + ".properties");
        if (Config.hasResource((amo)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static amo getLocationRandom(amo loc, boolean legacy) {
        String domain = loc.b();
        String path = loc.a();
        if (path.startsWith("optifine/")) {
            return loc;
        }
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (legacy) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new amo(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static amo getLocationIndexed(amo loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String separator = StrUtils.endsWithDigit((String)prefix) ? "." : "";
        String pathNew = prefix + separator + index + suffix;
        amo locNew = new amo(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    public static int[] getLocationsVariants(amo loc, boolean legacy, RandomEntityContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        amo locRandom = RandomEntities.getLocationRandom((amo)loc, (boolean)legacy);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            amo locIndex = RandomEntities.getLocationIndexed((amo)locRandom, (int)index);
            if (!Config.hasResource((amo)locIndex)) continue;
            list.add(index);
        }
        if (list.size() <= 1) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        int[] intArr = ArrayUtils.toPrimitive((Integer[])arr);
        Config.dbg((String)(context.getName() + ": " + loc.a() + ", variants: " + intArr.length));
        return intArr;
    }

    public static void update() {
        mapProperties.clear();
        mapSpriteProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            Object path = pathsRandom[i2];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            path = StrUtils.removeSuffix((String)path, (String)".");
            String pathBase = RandomEntities.getPathBase((String)(path = (String)path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            amo locBase = new amo(pathBase);
            if (!Config.hasResource((amo)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((amo)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(false));
            if (props == null) {
                props = RandomEntities.makeProperties((amo)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(true));
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static synchronized void registerSprites(amo atlasLocation, Set<amo> spriteLocations) {
        if (mapProperties.isEmpty()) {
            return;
        }
        String prefix = RandomEntities.getTexturePrefix((amo)atlasLocation);
        HashSet<amo> newLocations = new HashSet<amo>();
        for (amo loc : spriteLocations) {
            String pathFull = "textures/" + prefix + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null) continue;
            mapSpriteProperties.put(loc.a(), props);
            List locs = props.getAllResources();
            if (locs == null) continue;
            for (int i2 = 0; i2 < locs.size(); ++i2) {
                amo propLoc = (amo)locs.get(i2);
                amo locSprite = TextureUtils.getSpriteLocation((amo)propLoc);
                newLocations.add(locSprite);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        spriteLocations.addAll(newLocations);
    }

    private static String getTexturePrefix(amo atlasLocation) {
        if (atlasLocation.a().endsWith("/paintings.png")) {
            return "painting/";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ilp getRandomSprite(ilp spriteIn) {
        if (!active) {
            return spriteIn;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return spriteIn;
        }
        if (working) {
            return spriteIn;
        }
        try {
            ilp sprite;
            working = true;
            amo locSpriteIn = spriteIn.getName();
            String name = locSpriteIn.a();
            RandomEntityProperties props = (RandomEntityProperties)mapSpriteProperties.get(name);
            if (props == null) {
                ilp ilp2 = spriteIn;
                return ilp2;
            }
            amo loc = (amo)props.getResource(re, (Object)locSpriteIn);
            if (loc == locSpriteIn) {
                ilp ilp3 = spriteIn;
                return ilp3;
            }
            amo locSprite = TextureUtils.getSpriteLocation((amo)loc);
            ilp ilp4 = sprite = spriteIn.getTextureAtlas().a(locSprite);
            return ilp4;
        }
        finally {
            working = false;
        }
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }
}

