/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.IdentityHashMap;
import java.util.Map;
import net.optifine.Config;

public class NaturalProperties {
    public int rotation = 1;
    public boolean flip = false;
    private Map[] quadMaps = new Map[8];

    public NaturalProperties(String type) {
        if (type.equals("4")) {
            this.rotation = 4;
            return;
        }
        if (type.equals("2")) {
            this.rotation = 2;
            return;
        }
        if (type.equals("F")) {
            this.flip = true;
            return;
        }
        if (type.equals("4F")) {
            this.rotation = 4;
            this.flip = true;
            return;
        }
        if (type.equals("2F")) {
            this.rotation = 2;
            this.flip = true;
            return;
        }
        Config.warn((String)("NaturalTextures: Unknown type: " + type));
    }

    public boolean isValid() {
        if (this.rotation == 2 || this.rotation == 4) {
            return true;
        }
        return this.flip;
    }

    public synchronized hqa getQuad(hqa quadIn, int rotate, boolean flipU) {
        hqa quad;
        int index = rotate;
        if (flipU) {
            index |= 4;
        }
        if (index <= 0 || index >= this.quadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<hqa, hqa> map = this.quadMaps[index];
        if (map == null) {
            this.quadMaps[index] = map = new IdentityHashMap<hqa, hqa>(1);
        }
        if ((quad = (hqa)map.get(quadIn)) == null) {
            quad = this.makeQuad(quadIn, rotate, flipU);
            map.put(quadIn, quad);
        }
        return quad;
    }

    private hqa makeQuad(hqa quad, int rotate, boolean flipU) {
        int tintIndex = quad.j();
        iz face = quad.k();
        ilp sprite = quad.l();
        boolean shade = quad.m();
        int lightEmission = quad.n();
        if (!this.isFullSprite(quad)) {
            rotate = 0;
        }
        long[] uvs = this.transformVertexData(quad.getPackedUVs(), rotate, flipU);
        hqa quad2 = quad.makeCopy(uvs, quad.l());
        return quad2;
    }

    private long[] transformVertexData(long[] uvs, int rotate, boolean flipU) {
        long[] uvs2 = (long[])uvs.clone();
        int v2 = 4 - rotate;
        if (flipU) {
            v2 += 3;
        }
        v2 %= 4;
        for (int v = 0; v < 4; ++v) {
            uvs2[v2] = uvs[v];
            if (flipU) {
                if (--v2 >= 0) continue;
                v2 = 3;
                continue;
            }
            if (++v2 <= 3) continue;
            v2 = 0;
        }
        return uvs2;
    }

    private boolean isFullSprite(hqa quad) {
        ilp sprite = quad.l();
        float uMin = sprite.c();
        float uMax = sprite.d();
        float uSize = uMax - uMin;
        float uDelta = uSize / 256.0f;
        float vMin = sprite.f();
        float vMax = sprite.g();
        float vSize = vMax - vMin;
        float vDelta = vSize / 256.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float u2 = hdr.a((long)quad.b(i2));
            float v = hdr.b((long)quad.b(i2));
            if (!this.equalsDelta(u2, uMin, uDelta) && !this.equalsDelta(u2, uMax, uDelta)) {
                return false;
            }
            if (this.equalsDelta(v, vMin, vDelta) || this.equalsDelta(v, vMax, vDelta)) continue;
            return false;
        }
        return true;
    }

    private boolean equalsDelta(float x1, float x2, float deltaMax) {
        float deltaAbs = bgj.c((float)(x1 - x2));
        return deltaAbs < deltaMax;
    }
}

